IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Itau_UY_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Itau_UY_TX
END
GO

CREATE FUNCTION [dbo].[CF_Itau_UY_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT) 
RETURNS CHAR(200)
AS
BEGIN

/*Variables Archivo*/
DECLARE @Retorno					CHAR(200)
DECLARE @aCuenta_A_Debitar			VARCHAR(22)	/*Formato: Numérico (22) 		Nro. de Tarjeta del socio*/
DECLARE @aImporte					VARCHAR(11)	/*Formato: Numérico (9,2).		Monto correspondiente que se recibe por parámetro*/
DECLARE @aRef_Debito				VARCHAR(10)	/*Formato: Numérico (10).		Id_Cliente_externo del socio*/
DECLARE @aRef_Credito 				VARCHAR(1)		/*Formato: Numérico (1).		Se deberá completar siempre en blanco.*/
DECLARE @aConsumidor_Final 			VARCHAR(1)		/*Formato: Alfanumérico (1).	Se deberá completar siempre con la letra "S".*/
DECLARE @aMonto_Gravado 			VARCHAR(1)		/*Formato: Numérico (1).		Se deberá completar siempre en Cero.*/
DECLARE @aImporte_Ret_Iva 			VARCHAR(1)		/*Formato: Numérico (1).		Se deberá completar siempre en Cero.*/
DECLARE @aNumero_Factura			VARCHAR(1)		/*Formato: Alfanumérico (1).	Se deberá completar siempre en blanco.*/
/*FIN Variables Archivo*/

/*Variable Locales*/
DECLARE @Tar_Nro				VARCHAR(22)
DECLARE @Id_Cliente				INT
DECLARE @Id_Cliente_Externo		INT
/*FIN Variable Locales*/

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

/*Seteo Variables Locales*/

SELECT	
@Tar_Nro				= ISNULL(Nro, '')
FROM Val_Tarjetas_Lotes_Items 
WHERE
Id_Tar_Lote = @pId_Tar_Lote
AND Id_Trans = @pId_Trans


SELECT	
@Id_Cliente				= ISNULL(Id_Cliente, 0)
FROM Cbtes 
WHERE
Id_Trans = @pId_Trans


SELECT 
@Id_Cliente_Externo		= ISNULL(Id_Cliente_Externo, Id_Cliente)
FROM Clientes
WHERE
Id_Cliente = @Id_Cliente

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

SET @aCuenta_A_Debitar			=	@Tar_Nro

SET @aImporte					=	@pImporte

SET @aRef_Debito				=	@Id_Cliente_Externo

SET @aRef_Credito				=	''

SET @aConsumidor_Final			=	'S'

SET @aMonto_Gravado				=	'0'

SET @aImporte_Ret_Iva			=	'0'

SET @aNumero_Factura			=	''

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

SET @Retorno =	@aCuenta_A_Debitar	 + ';' +
				@aImporte 		   	 + ';' +
				@aRef_Debito 		 + ';' +
				@aRef_Credito  		 + ';' +
				@aConsumidor_Final 	 + ';' +
				@aMonto_Gravado		 + ';' +
				@aImporte_Ret_Iva 	 + ';' +
				@aNumero_Factura

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

RETURN ISNULL(@Retorno, '                                                                                                                                                                                                        ')
END
